function varargout = chris_burst_manual_gui(A)
% res = chris_burst_manual_gui()
%
% A program to manually browse synaptic bursts.

% Sep 13 2014: Converted from another file (the one for step injections).
% Jan 16 2015: Now button Z makes a figure for each cell.


fileName = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Synaptic data.xlsx';
fileFolder = 'C:\Users\Arseny\Documents\4_Cells Classification\2014 data\Synaptic Bursts - semiprocessed by Angelia\LongAveraged\';
sheetKey = 'key';

%%%%% ========================================== CLARIFYING INPUT DATA ===============================
if(nargin<1)
    fprintf('No arguments, so reading a file now... ');
    [keyNum,keyText] = xlsread(fileName,sheetKey);

    fprintf('Done\n');

    ids      = keyNum;
    matFiles = {keyText{2:end,1}};      % That's where they seem to end up
    
    A.ids = ids;
    A.files = matFiles;
    varargout{1} = A;                   % Pack into a structure and send back, for faster work
    return;
else
    ids = A.ids;                        % Unpack
    matFiles = A.files;    
    fprintf('Input data received and unpacked\n');
end

S.matFiles = matFiles;   % Send a copy to S
S.fileFolder = fileFolder;

%%%%% ========================================== Pre-processing ===============================
S.nCell   = length(ids);
S.iCell   = 1;                          % Current cell
S.oldiCell = 0;                         % Creating a discrepancy to trigger proper abf reading
S.ids = ids;                            % Mostly for output purposes
S.iTrace = 5;                           % Current trace (actually ISI used)
S.oldiTrace = 5;                        % For detecting a change in iTrace

showWindow = [100 250];                 % in ms

win1 = [110 120]*10;                    % in points (10 points per ms): monosynaptic window
win2 = [120 205]*10;                    % polysynaptic window
                                        % The stimulus was apparently delivered ~105 ms, so 110 is 5 ms after the stimulus.
S.winRatio = [];

%%%%% ========================================== CREATING GUI ===============================
hF = figure('Color','white');
fpos = get(hF,'Position');
set(hF,'Position',[fpos(1)-fpos(3)/2 fpos(2) fpos(3)*2 fpos(4)]); drawnow; % Without 'drawnow' returns an error every now and then (when position is requested before being finalized)
set(hF,'WindowButtonMotionFcn',@hoverfunction,'ButtonDownFcn',@mousepressfunction,'KeyPressFcn',@keyfunction,'ResizeFcn',@resizefunction);
S.hA = axes;
hold on; % Pre-create high level graphic objects here

S.hP = plot(0,0,'k-');
S.hText = text(0,0,'Heh =)');
S.hMean1 = plot(win1/10,[0 0],'r-');
S.hMean2 = plot(win2/10,[0 0],'r-');
hold off;
S.hTitle = title('');
set(S.hA,'Xlim',showWindow);

% Set mouse function for all created objects, as axes function won't work for them
set(S.hA,'ButtonDownFcn',@mousepressfunction);
set(S.hP,'ButtonDownFcn',@mousepressfunction);

% Initialize global variables here
S.flagUpdate = 1; % When set to 1, the main function will be called

% Initialize local variables here
flag = 1; % Main rotating flag (while==1, the program runs)

set(hF,'UserData',S); % Send the stuff there
resizefunction;

while(flag)
    try
        S = get(hF,'UserData');
    catch % Probably the figure was closed
        flag = 0; break; % Leave the cycle
    end
    
    if(S.flagUpdate) % Somebody pressed the button - time to move to the next sweep    
        if(S.oldiCell~=S.iCell)
            S.iTrace = 5;
            rawData = read_raw_data(S,fileFolder,matFiles,S.iTrace);    % Read the data            
            xData = (1:size(rawData,1))/10;                             % Recook x-data                        
            S.oldiCell = S.iCell;                   
        end
        if(S.oldiTrace~=S.iTrace)
            rawData = read_raw_data(S,fileFolder,matFiles,S.iTrace);    % Read the data            
            xData = (1:size(rawData,1))/10;                             % Recook x-data     
            S.oldiTrace = S.iTrace;
        end
        mean1 = mean(rawData(win1(1):win1(2)));
        mean2 = mean(rawData(win2(1):win2(2)));
        locmax = max(abs(rawData(win1(1):win1(2))));
        fprintf('%e\n',locmax);
        S.winRatio(S.iCell) = mean2/mean1;
        
        set(S.hP,'YData',rawData(:),'XData',xData);
        set(S.hTitle,'String',[num2str(ids(S.iCell)) ' - # ' num2str(S.iTrace)]);
        set(S.hMean1,'YData',mean1*[1 1]);
        set(S.hMean2,'YData',mean2*[1 1]);
        
        pos = get(S.hA,'YLim');
        %set(S.hText,'Position',[250 pos(1)+(pos(2)-pos(1))*0.8],'String',...
        %    sprintf('ISI = %4.1f\nISI 2/1 = %3.1f\namp 1/2 = %3.1f',isi,isi21,amp12));
        
        S.flagUpdate = 0;
        set(hF,'UserData',S);        
    end
    drawnow;    
end

fprintf('\n');
% fprintf('.... Finished\n');
try % Enclosed in 'try' because the figure may be closed already by the user
    pause(0.1);
    close(hF);
end

end



function hoverfunction(h,event)
hF = gcf; S = get(hF,'UserData'); % Get use data
xy = get(hF,'CurrentPoint'); % Mouse location in figure coordinates
axesPos = get(S.hA,'Position');
figPos = get(hF,'Position');
S.x = (xy(1)/figPos(3)-axesPos(1))/axesPos(3); % Recalcualte into relative position within the axes
S.y = (xy(2)/figPos(4)-axesPos(2))/axesPos(4);

xLim = get(S.hA,'XLim');
yLim = get(S.hA,'YLim');
xx = (xLim(1)+(xLim(2)-xLim(1))*S.x);
yy = (yLim(1)+(yLim(2)-yLim(1))*S.y);
if((S.x>0)&&(S.x<1))
    %set(S.hP,'XData',xx,'YData',yy);
end

set(hF,'UserData',S); % Push data back
end


function mousepressfunction(h,event)
hF = gcf; S = get(hF,'UserData');
xy = get(hF,'CurrentPoint');
axesPos = get(S.hA,'Position');
figPos = get(hF,'Position');
S.xb = (xy(1)/figPos(3)-axesPos(1))/axesPos(3);
S.yb = (xy(2)/figPos(4)-axesPos(2))/axesPos(4);
S.flagNext = 1;
xl = get(S.hA,'XLim');
yl = get(S.hA,'YLim');
fprintf('Point: %d %d\n',round(xl(1)+(xl(2)-xl(1))*S.xb),round(yl(1)+(yl(2)-yl(1))*S.yb));
set(hF,'UserData',S);
end


function resizefunction(h,event)
hF = gcf; S = get(hF,'UserData');
% Do something here
set(hF,'UserData',S);
end


function keyfunction(h,event)
hF = gcf; S = get(hF,'UserData');
switch(event.Key)
    case {'a','leftarrow'}
        S.iCell = max(1,S.iCell-1);
        S.flagUpdate = 1;
    case {'d','rightarrow'}
        S.iCell = min(S.nCell,S.iCell+1);
        S.flagUpdate = 1;
    case {'w','uparrow'}
        S.iTrace = min(5,S.iTrace+1);
        S.flagUpdate = 1;
    case {'s','downarrow'}
        S.iTrace = max(1,S.iTrace-1);
        S.flagUpdate = 1;
    case 'z'
        draw_raw_data(S,S.fileFolder,S.matFiles,S.iTrace);
    case 'space'
    case 'return'
        fprintf('OUTPUT:\n');
        dispf({'id','ratio'});
        dispf(concatenan(S.ids(:),S.winRatio(:)));
    otherwise
        %fprintf('%s - :)\n',event.Key);        
end
set(hF,'UserData',S);
end


function myAverage = read_raw_data(S,fileFolder,abfFiles,dummy)
% Reads an appropriate abf file
fprintf('Reading: %s\n',abfFiles{S.iCell});
temp = load([fileFolder abfFiles{S.iCell}]);
myAverage = [];
for(iTrace=1:5)
    if(isfield(temp,'c014_Im_scaled'))
        switch(iTrace)                                      % 14 11 8 5 2
            case 5
                rawData = temp.c014_Im_scaled(:);        % Older files
            case 4
                rawData = temp.c011_Im_scaled(:);        % Older files
            case 3
                rawData = temp.c008_Im_scaled(:);        % Older files
            case 2
                rawData = temp.c005_Im_scaled(:);        % Older files
            case 1
                rawData = temp.c002_Im_scaled(:);        % Older files
        end    
    else
        rawData = temp.num(:,iTrace);               % Newer files    
    end
    if(isempty(myAverage))
        myAverage = rawData;
    else
        myAverage = myAverage + rawData;
    end
end
myAverage = myAverage/5;
end


function draw_raw_data(S,fileFolder,abfFiles,dummy)
% Reads an appropriate abf file
fprintf('Reading: %s\n',abfFiles{S.iCell});
temp = load([fileFolder abfFiles{S.iCell}]);
mycolors = 'krgbcmkrgbcmkrgbcm';
hf = figure; hold on;
for(iTrace=1:5)
    if(isfield(temp,'c014_Im_scaled'))
        switch(iTrace)                                      % 14 11 8 5 2
            case 5
                rawData = temp.c014_Im_scaled(:);        % Older files
            case 4
                rawData = temp.c011_Im_scaled(:);        % Older files
            case 3
                rawData = temp.c008_Im_scaled(:);        % Older files
            case 2
                rawData = temp.c005_Im_scaled(:);        % Older files
            case 1
                rawData = temp.c002_Im_scaled(:);        % Older files
        end    
    else
        rawData = temp.num(:,iTrace);               % Newer files    
    end
    plot(rawData+iTrace*1e-11,'Color',mycolors(iTrace));
end
hold off;
end